% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore-plot.R
\name{explore_plot}
\alias{explore_plot}
\title{Create Basic Barplots}
\usage{
explore_plot(data, var, nbar = 8, palette = "Dark2", na.rm = TRUE)
}
\arguments{
\item{data}{The data frame to explore.}

\item{var}{A variable to plot.}

\item{nbar}{The number of bars to plot. Always shows most common values.}

\item{palette}{The color palette passed to [ggplot2::scale_fill_brewer().}

\item{na.rm}{logical: Should \code{NA} values of \code{var} be removed?}
}
\value{
A \code{ggplot} barplot object. Can then be combined with other \code{ggplot}
layers with \code{+} to customize.
}
\description{
This function simply wraps around \code{\link[ggplot2:geom_bar]{ggplot2::geom_col()}} to take a dataframe
and categorical variable to return a custom barplot \code{ggplot} object. The bars
are arranged in descending order and are limited to the 8 most frequent
values.
}
\examples{
explore_plot(ggplot2::diamonds, cut)
}
