% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{msebmtcal}
\alias{msebmtcal}
\title{European Group for Blood and Marrow Transplantation data}
\format{
\subsection{'msebmtcal'}{

A data frame in \code{msdata} format (see \code{\link[mstate]{msprep}}) with 15,512 rows and 8 columns:
\describe{
\item{id}{Patient indentifier}
\item{from}{transition from state}
\item{to}{transition to state}
\item{trans}{transition number}
\item{Tstart}{time entered state 'from'}
\item{Tstop}{time leaving state 'from'}
\item{time}{time in state 'from'}
\item{status}{event indicator, 1:transitioned to state 'to'}
}
}
}
\source{
This dataset was derived from data made available within the \code{mstate} package, see \code{\link[mstate]{ebmt4}}.
The data was originally provided by the European Group for Blood and Marrow Transplantation (https://www.ebmt.org/).
We reiterate the source statement given by the developers of \code{mstate}:
"We acknowledge the European Society for Blood and Marrow Transplantation (EBMT)
for making available these data. Disclaimer: these data were simplified for the
purpose of illustration of the analysis of competing risks and multi-state models
and do not reflect any real life situation. No clinical conclusions should be
drawn from these data."
}
\usage{
msebmtcal
}
\description{
The \code{\link[mstate]{ebmt4}} data converted into \code{msdata} format (see \code{\link[mstate]{msprep}}),
using the processes implemented in the \code{mstate} package. Code for the derivation
of this dataset is provided in the source code for the package.
}
\references{
EBMT (2023). “Data from the European Society for Blood and Marrow Transplantation.”
URL https://search.r-project.org/CRAN/refmans/mstate/html/EBMT-data.html.

de Wreede LC, Fiocco M, Putter H (2011). “mstate: An R Package for the Analysis of
Competing Risks and Multi-State Models.” \emph{Journal of Statistical Software}, 38(7).
}
\keyword{datasets}
