% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survreg.penal.R
\name{axe-survreg.penal}
\alias{axe-survreg.penal}
\alias{axe_call.survreg.penal}
\alias{axe_data.survreg.penal}
\alias{axe_env.survreg.penal}
\title{Axing an survreg.penal}
\usage{
\method{axe_call}{survreg.penal}(x, verbose = FALSE, ...)

\method{axe_data}{survreg.penal}(x, verbose = FALSE, ...)

\method{axe_env}{survreg.penal}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed survreg object.
}
\description{
survreg.penal objects are created from the \pkg{survival} package. They
are returned from the \code{survreg} function, representing fitted
parametric survival models.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "survival"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load libraries
library(parsnip)
library(survival)

# Create model and fit
survreg_fit <- surv_reg(mode = "regression", dist = "weibull") \%>\%
  set_engine("survival") \%>\%
  fit(Surv(time, status) ~ rx, data = rats)

out <- butcher(survreg_fit, verbose = TRUE)

# Another survreg.penal object
wrapped_survreg.penal <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- survreg(Surv(time, status) ~ rx,
                 data = rats, subset = (sex == "f"))
  return(fit)
}

# Remove junk
cleaned_sp <- axe_env(wrapped_survreg.penal(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned_sp)
\dontshow{\}) # examplesIf}
}
