% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sea.R
\name{sea}
\alias{sea}
\title{Perform superposed epoch analysis.}
\usage{
sea(x, event, nbefore = 6, nafter = 4, event_range = TRUE,
  n_iter = 1000)
}
\arguments{
\item{x}{A data.frame climate reconstruction or tree-ring series with row names as years.}

\item{event}{A vector of event years for superposed epoch, such as fire years, or an fhx object
with a single \code{series} as produced by \code{composite}}

\item{nbefore}{The number of lag years prior to the event year}

\item{nafter}{The number of lag years following the event year}

\item{event_range}{Logical. Constrains the time series to the time period of key events within the range
of the x climate series. False uses the entire climate series, ignoring the period of key events.
time series}

\item{n_iter}{The number of iterations for bootstrap resampling}
}
\value{
A sea object containing, (1) a vector of event years, (2) a data.frame summary of the actual events composite,
(3) a data.frame summary of the simulated events composite, (4) a data.frame summary of the departures of actual from simulated events,
(5) a matrix of the actual events composite, and (6) a matrix of simulated events composite.
}
\description{
Perform superposed epoch analysis.
}
\details{
Superposed epoch analysis (SEA) helps to evaluate fire-climate
relationships in studies of tree-ring fire history. It works by compositing the values of
an annual timeseries or climate reconstruction for the fire years provided (\code{key}) and both positive and
negative lag years. Bootstrap resampling of the timeseries is performed to evaluate the statistical
significance of each year's mean value. Users interpret the departure of the actual event year
means from the simulated event year means. Note that there is no rescaling of the climate time series 'x'.

The significance of lag-year departures from the average climate condition was first noted by
Baisan and Swetnam (1990) and used in an organized SEA by Swetnam (1993). Since then, the procedure
has been commonly applied in fire history studies. The FORTRAN program EVENT.exe was written by
Richard Holmes and Thomas Swetnam (Holmes and Swetnam 1994) to perform SEA for fire history
specifically. EVENT was incorporated in the FHX2 software by Henri Grissino-Mayer.
Further information about SEA can be found in the FHAES user's manual, http://help.fhaes.org/

sea was designed to replicate EVENT as closely as possible. We have tried to stay true to their implementation of
SEA, although multiple versions of the analysis exist in the climate literature and for fire
history. The outcome of EVENT and sea should
only differ slightly in the values of the simulated events and the departures, because random
draws are used. The event year and lag significance levels should match, at least in the general
pattern.

We note that our implementation of \code{sea} borrows from the \code{dplR::sea} function in how it performs
the bootstrap procedure, but differs in the kind of output provided for the user.
}
\examples{
\dontrun{
# Read in the Cook and Krusic (2004; The North American Drought Atlas) reconstruction
# of Palmer Drought Severity Index (PDSI) for the Jemez Mountains area (gridpoint 133).
}
\dontrun{
# For users who want to perform SEA very near to EVENT.exe and/or have reproducable draws from
# the bootstrap procedure, consider including the \\code{set.seed} function prior to \\code{run_sea}.
# Convention is to provide a long integer, such as a birthday (e.g. 3191982).
# In the EVENT.exe program, Richard Holmes used the number of days since 1 January 1935.
days <- as.numeric(Sys.Date() - as.Date("1jan1935", "\%d\%b\%Y"))
set.seed(days)
}

}
\references{
Baisan and Swetnam 1990, Fire history on desert mountain range: Rincon Mountain Wilderness, Arizona, U.S.A. Canadian Journal of Forest Research 20:1559-1569.

Bunn 2008, A dendrochronology program library in R (dplR), Dendrochronologia 26:115-124

Holmes and Swetnam 1994, EVENT program description

Swetnam 1993, Fire history and climate change in giant sequoia groves, Science 262:885-889.
}
