% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hist.R
\name{plot_hist}
\alias{plot_hist}
\title{Plot Histogram}
\usage{
plot_hist(z_vector, binv = "median", zstar, binwidth, bins_l, bins_r,
  p_title = "", p_xtitle = "z_name", p_ytitle = "Count",
  p_title_size = 11, p_axis_title_size = 10, p_axis_val_size = 8.5,
  p_miny = 0, p_maxy = NA, p_ybreaks = NA,
  p_grid_major_y_color = "lightgrey", p_freq_color = "black",
  p_zstar_color = "red", p_freq_size = 0.5, p_freq_msize = 1,
  p_zstar_size = 0.5, p_zstar = TRUE)
}
\arguments{
\item{z_vector}{a numeric vector of (unbinned) data.}

\item{binv}{a string setting location of zstar within its bin ("min", "max" or "median" value). Default is median.}

\item{zstar}{a numeric value for the the bunching point.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{bins_l}{number of bins to left of zstar to use in analysis.}

\item{bins_r}{number of bins to right of zstar to use in analysis.}

\item{p_title}{plot's title. Default is empty.}

\item{p_xtitle}{plot's x_axis label. Default is the name of z_vector.}

\item{p_ytitle}{plot's y_axis label. Default is "Count".}

\item{p_title_size}{size of plot's title. Default is 11.}

\item{p_axis_title_size}{size of plot's axes' title labels. Default is 10.}

\item{p_axis_val_size}{size of plot's axes' numeric labels. Default is 8.5.}

\item{p_miny}{plot's minimum y_axis value. Default is 0.}

\item{p_maxy}{plot's maximum y_axis value. Default is optimized internally.}

\item{p_ybreaks}{a numeric vector of y-axis values at which to add horizontal line markers in plot. Default is optimized internally.}

\item{p_grid_major_y_color}{plot's y-axis major grid line color. Default is "lightgrey".}

\item{p_freq_color}{plot's frequency line color. Default is "black".}

\item{p_zstar_color}{plot's bunching region marker lines color. Default is "red".}

\item{p_freq_size}{plot's frequency line thickness. Default is 0.5.}

\item{p_freq_msize}{plot's frequency line marker size. Default is 1.}

\item{p_zstar_size}{plot's bunching region marker line thickness. Default is 0.5.}

\item{p_zstar}{whether to show vertical line for zstar. Default is TRUE.}
}
\value{
\code{plot_hist} returns a list with the following:
  \item{plot}{the plot of the density without estimating a counterfactual.}
  \item{data}{the binned data used for the plot.}
}
\description{
Create a binned plot for quick exploration without estimating bunching mass.
}
\examples{

# visualize a distribution
data(bunching_data)
plot_hist(z_vector = bunching_data$kink_vector,
binv = "median", zstar = 10000,
binwidth = 50, bins_l = 40, bins_r = 40)$plot

}
\seealso{
\code{\link{bunchit}}
}
