% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRNCisPanel.R
\name{GRNCisPanel}
\alias{GRNCisPanel}
\alias{GRNCisPanelUI}
\alias{GRNCisPanelServer}
\title{Generate the GRN cis integration panel of the shiny app}
\usage{
GRNCisPanelUI(id, reference.table.name, comparison.table.name)

GRNCisPanelServer(
  id,
  expression.matrix,
  anno,
  coord.table.reference,
  coord.table.comparison,
  seed = 13
)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{reference.table.name}{Name for reference expression matrix and coordinate table}

\item{comparison.table.name}{Name for comparison coordinate table}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}

\item{coord.table.reference}{Table of coordinates corresponding to rows of
expression.matrix}

\item{coord.table.comparison}{Table of coordinates to compare against coord.table.reference}

\item{seed}{Random seed to create reproducible GRNs}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of the GRN cis integration
panel of the shiny app. It is generated by including at least 1 row in the
cis.integration parameter of \code{\link{generateShinyApp}}.
}
