% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessExpressionMatrix.R
\name{preprocessExpressionMatrix}
\alias{preprocessExpressionMatrix}
\title{Pre-process the expression matrix before generating the shiny app}
\usage{
preprocessExpressionMatrix(
  expression.matrix,
  denoise = TRUE,
  output.plot = FALSE,
  normalisation.method = c("quantile", "rpm", "tmm", "deseq2"),
  ...
)
}
\arguments{
\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples}

\item{denoise}{whether to use noisyR to denoise the expression matrix;
proceeding without denoising data is not recommended}

\item{output.plot}{whether to create an expression-similarity plot for the
noise analysis (printed to the console); default is FALSE}

\item{normalisation.method}{the normalisation method to be used; default is
quantile; any unrecognised input will result in no normalisation being
applied, but proceeding with un-normalised data is not recommended;
currently supported normalisation methods are:
\describe{
\item{quantile}{Quantile normalisation using the \code{normalize.quantiles}
function from the \code{preprocessCore} package}
\item{rpm}{A version of RPM (reads per million) normalisation, where each
sample is scaled by the median expression in the sample divided by the
total number of reads in that sample}
\item{tmm}{Trimmed Mean of M values normalisation using the
\code{calcNormFactors} function from the \code{edgeR} package}
\item{deseq2}{Size factor normalisation using the
\code{estimateSizeFactorsForMatrix} function from the \code{DESeq2} package}
}}

\item{...}{optional arguments passed on to \code{noisyr::noisyr_counts()}}
}
\value{
The denoised, normalised expression matrix; some rows (genes)
may have been removed by noisyR.
}
\description{
This function denoises the expression matrix using the noisyR package
and then normalises it. It is recommended to use this function before using
\code{\link{generateShinyApp}}.
}
\examples{
expression.matrix <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:10, 1:4]
expression.matrix.preproc <- preprocessExpressionMatrix(expression.matrix)
}
