% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tergmprepare.R
\name{tergmprepare}
\alias{tergmprepare}
\title{Prepare data structure for TERGM estimation, including composition change}
\usage{
tergmprepare(formula, offset = TRUE, blockdiag = FALSE, verbose = TRUE)
}
\arguments{
\item{formula}{The original formula provided by the user, given the data
structures in the workspace.}

\item{offset}{Indicates whether absent nodes should be added where they are
missing (\code{offset = TRUE}) or removed where they are not missing
(\code{offset = FALSE}).}

\item{blockdiag}{Should the time steps be arranged in a blockdiagonal matrix
for use with MCMC-MLE or Bayesian estimation (\code{blockdiag = TRUE}), or
should they be kept as items in a list for use with \code{\link{btergm}}
(\code{blockdiag = FALSE})?}

\item{verbose}{Report details about dimension adjustment?}
}
\value{
A list with the following slots:
\describe{
  \item{lhs.original}{A character object containing the original name of the
    object on the left-hand side of the formula provided by the user. This is
    saved here because the formula is manipulated such that the left-hand
    side of the formula contains a new item \code{networks[[i]]}.}
  \item{networks}{The list of networks on the left-hand side of the formula
    after dimension adjustment, or a blockdiagonal network representing the
    left-hand side of the formula after dimension adjustment if argument
    \code{blockdiag = TRUE} was used.}
  \item{num.vertices}{The maximum number of nodes of any time point after
    adjustment of dimensions.}
  \item{directed}{Are the networks directed?}
  \item{bipartite}{Are the networks bipartite?}
  \item{form}{The formula after manipulation and adjustment of the data,
    including \code{networks[[i]]} on the left-hand side and an added offset
    covariate on the right-hand side of the formula, in addition to added
    indices for the covariate terms.}
  \item{time.steps}{The number of time steps of the dataset.}
  \item{rhs.terms}{The right-hand side of the formula after adjustment, as
    a vector of \code{character} objects representing the terms.}
  \item{covnames}{A \code{character} vector containing the names of the
    objects in which the networks and covariates are stored, according to the
    manipulated formula. This includes \code{"networks"} (for the left-hand
    side of the formula) and all objects containing exogenous covariates on
    the right-hand side of the formula after manipulation.}
  \item{...}{Each of the covariates mentioned in the slot \code{covnames} is
    stored as an element of the list, either as a list of matrices or
    networks (if \code{blockdiag = FALSE}) or as a matrix or network object
    (if \code{blockdiag = TRUE}).}
  \item{auto.adjust}{Did the function have to adjust the dimensions of the
    networks or covariates at all?}
  \item{nvertices}{A matrix containing the number of nodes in the rows and
    columns of each object at each time step, after adjustment.}
  \item{offsmat}{A list of offset covariate matrices or a large blockdiagonal
    offset covariate matrix containing structural zeros. If
    \code{offset = FALSE}, this matrix or list of matrices will contain only
    zeros. If \code{offset = TRUE}, they will contain ones where nodes were
    absent in the original data.}
}
}
\description{
Prepare data structure for TERGM estimation, including composition change.
}
\details{
This is a helper function that adjusts the dimensions of networks or
covariates within a given time step to each other by removing nodes that are
not present across all objects within a time step or by adding nodes where
they are missing (and simultaneously adding entries to a list of structural
zero matrices to indicate their absence). It is not necessary to have
identical (numbers of) nodes across time steps as long as the dimensions of
the matrices, networks, and vectors match cross-sectionally within time
steps, given that temporal dependency terms like memory are interpreted as
dyadic covariates in a given time step. This helper function also creates
these dyadic covariate data structures for some of the custom temporal model
terms, such as \code{memory} and \code{delrecip}. Leifeld, Cranmer and
Desmarais (2018) contain additional details on composition change, dimension
adjustment of matrices, and temporal dependencies. Note that this function
should not normally be used by the end user. It is automatically called
internally by the estimation functions to make the dimensions of all objects
conformable to each other for estimation. Use this function only for
diagnostic purposes!
}
\author{
Philip Leifeld
}
