% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_variance_decompositions.R
\name{compute_variance_decompositions}
\alias{compute_variance_decompositions}
\title{Computes posterior draws of the forecast error variance decomposition}
\usage{
compute_variance_decompositions(posterior, horizon)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of one of the classes: 
PosteriorBSVAR, PosteriorBSVARMSH, PosteriorBSVARMIX, or PosteriorBSVARSV
obtained by running the \code{estimate} function. The interpretation depends on the normalisation of the shocks
using function \code{normalise_posterior()}. Verify if the default settings are appropriate.}

\item{horizon}{a positive integer number denoting the forecast horizon for the impulse responses computations.}
}
\value{
An object of class PosteriorFEVD, that is, an \code{NxNx(horizon+1)xS} array with attribute PosteriorFEVD 
containing \code{S} draws of the forecast error variance decomposition.
}
\description{
Each of the draws from the posterior estimation of a model
is transformed into a draw from the posterior distribution of the forecast error variance decomposition.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 2)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in$get_last_draw(), 50)

# compute forecast error variance decomposition 2 years ahead
fevd           = compute_variance_decompositions(posterior, horizon = 8)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 2) |>
  estimate(S = 10) |> 
  estimate(S = 50) |> 
  compute_variance_decompositions(horizon = 8) -> fevd

}
\references{
Kilian, L., & Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{compute_impulse_responses}}, \code{\link{estimate}}, \code{\link{normalise_posterior}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
