% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_bscui_ui_elements.R
\name{set_bscui_ui_elements}
\alias{set_bscui_ui_elements}
\title{Set UI elements of a bscui widget}
\usage{
set_bscui_ui_elements(widget, ui_elements)
}
\arguments{
\item{widget}{a \code{\link{bscui}} object}

\item{ui_elements}{NULL or a data frame with the following columns:
\itemize{
\item \strong{id}: the element identifier
\item \strong{ui_type}: either "selectable" (several elements can be selected),
"button" (action will be triggered on click), "none" (no ui)
\item \strong{title}: a description of the element to display on mouseover event
}}
}
\value{
The modified \code{\link{bscui}} object
}
\description{
Set UI elements of a bscui widget
}
\examples{
##################################@
### Preparing data ----

library(bscui)
library(xml2)
library(readr)
library(dplyr)

svg <- xml2::read_xml(system.file(
   "examples", "Animal_cells.svg.gz",
   package="bscui"
))
info <- readr::read_tsv(system.file(
   "examples", "uniprot_cellular_locations.txt.gz",
   package="bscui"
), col_types=strrep("c", 6)) |>
   mutate(id = sub("-", "", `Subcellular location ID`))

##################################@
### Building the figure ----

figure <- bscui(svg) |>
   set_bscui_ui_elements(
      info |>
         mutate(
            ui_type = "selectable",
            title = Name
         ) |>
         select(id, ui_type, title)
   ) |>
   set_bscui_styles(
      info |>
         filter(Name == "Cytosol") |>
         mutate(fill = "#FF7F7F") |>
         select(id, fill)
   ) |>
   set_bscui_attributes(
      info |>
         filter(Name == "Cytoskeleton") |>
         mutate(display = "none") |>
         select(id, display)
   ) |>
   set_bscui_selection("SL0188") |>
   set_bscui_options(zoom_min=1, clip=TRUE)
figure

##################################@
### Saving the figure ----

if(interactive()){
   ## Temporary directory to save example file
   tdir <- tempdir()

   ## Interactive html file
   f_path <- file.path(tdir, "figure.html")
   figure |> htmlwidgets::saveWidget(file=f_path)
   cat(f_path)

   ## PNG image
   f_path <- file.path(tdir, "figure.png")
   figure |>
      set_bscui_options(show_menu = FALSE) |>
      export_bscui_to_image(file=f_path, zoom=2)
   cat(f_path)
}
}
