% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brxx_ICC.R
\name{brxx_ICC}
\alias{brxx_ICC}
\title{brxx_ICC: Bayesian Estimation of Reliability from ICC}
\usage{
brxx_ICC(mod, alpha, beta, CI)
}
\arguments{
\item{mod}{A mixed effects model object estimated by blmer.}

\item{alpha}{Prior true score variance (subject variance)}

\item{beta}{Prior error variance (residual variance)}

\item{CI}{Credible interval quantile, as a decimal (ie, for 95 percent, 0.95).}
}
\value{
Returns estimated median and quantile based credible limits for ICC.
}
\description{
This function estimates reliability from intraclass correlation coefficient
}
\examples{
\donttest{
your_data_wide=mvrnorm(20,c(0,0),matrix(c(1,0.8,0.8,1),nrow=2,ncol=2))
your_data_long=c(as.vector(your_data_wide[,1]),as.vector(your_data_wide[,2]))
time=c(rep(0,20),rep(1,20))
id=c(rep(1:20,2))
mod=blmer(your_data_long~time+(1|id))
brxx_ICC(mod=mod,alpha=3.51,beta=1.75,CI=0.95)}

}
