% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_05_advance.R
\name{granger_test}
\alias{granger_test}
\title{Granger causality test (bivariate).}
\usage{
granger_test(formula, data, lags = 1:5, test.reverse = TRUE, file = NULL)
}
\arguments{
\item{formula}{Model formula like \code{y ~ x}.}

\item{data}{Data frame.}

\item{lags}{Time lags. Default is \code{1:5}.}

\item{test.reverse}{Whether to test reverse causality. Default is \code{TRUE}.}

\item{file}{File name of MS Word (\code{.doc}).}
}
\value{
A data frame of results.
}
\description{
Granger test of predictive causality (between two time series)
using the \code{\link[lmtest:grangertest]{lmtest::grangertest()}} function.
}
\details{
Granger causality test examines whether
the lagged values of a predictor
have an incremental role in predicting (i.e., help to predict)
an outcome when controlling for the lagged values of the outcome.

Granger causality does not necessarily constitute a true causal effect.
}
\examples{
granger_test(chicken ~ egg, data=lmtest::ChickEgg)
granger_test(chicken ~ egg, data=lmtest::ChickEgg, lags=1:10, file="Granger.doc")
unlink("Granger.doc")  # delete file for code check

}
\seealso{
\code{\link{ccf_plot}},
\code{\link{granger_causality}}
}
