% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_02_scale.R
\name{CFA}
\alias{CFA}
\title{Confirmatory factor analysis (CFA).}
\usage{
CFA(
  data,
  model = "A =~ a[1:5]; B =~ b[c(1,3,5)]; C =~ c1 + c2 + c3",
  highorder = "",
  orthogonal = FALSE,
  missing = "listwise",
  style = "lavaan",
  CI = FALSE,
  MI = FALSE
)
}
\arguments{
\item{data}{Data frame.}

\item{model}{Model formula. See examples.}

\item{highorder}{High-order factor. Default is \code{""}.}

\item{orthogonal}{Default is \code{FALSE}. If \code{TRUE}, all covariances among latent variables are set to zero, and only "lavaan" style will be output.}

\item{missing}{Default is \code{"listwise"}. Alternative is \code{"fiml"} (using "Full Information Maximum Likelihood" method to estimate the model).}

\item{style}{\code{"jmv"}, \code{"lavaan"} (default), or both \code{c("jmv", "lavaan")}.
If the model has high-order factors, only "lavaan" style will be output.}

\item{CI}{\code{TRUE} or \code{FALSE} (default), provide confidence intervals for the model estimates.}

\item{MI}{\code{TRUE} or \code{FALSE} (default), provide modification indices for the parameters not included in the model.}
}
\value{
A list of results returned by \code{\link[jmv:cfa]{jmv::cfa()}}
and \code{\link[lavaan:cfa]{lavaan::cfa()}}.
}
\description{
An extension of \code{\link[jmv:cfa]{jmv::cfa()}} and \code{\link[lavaan:cfa]{lavaan::cfa()}}.
}
\examples{
\donttest{data.cfa=lavaan::HolzingerSwineford1939
CFA(data.cfa, "Visual =~ x[1:3]; Textual =~ x[c(4,5,6)]; Speed =~ x7 + x8 + x9")
CFA(data.cfa, model="
    Visual =~ x[1:3]
    Textual =~ x[c(4,5,6)]
    Speed =~ x7 + x8 + x9
    ", highorder="Ability")

data.bfi=na.omit(psych::bfi)
CFA(data.bfi, "E =~ E[1:5]; A =~ A[1:5]; C =~ C[1:5]; N =~ N[1:5]; O =~ O[1:5]")
}
}
\seealso{
\code{\link[jmv:cfa]{jmv::cfa()}}

\code{\link[lavaan:cfa]{lavaan::cfa()}}
}
