% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtavg.R, R/ptavg.R
\name{dtavg}
\alias{dtavg}
\alias{ptavg}
\title{Average of the Student t Distribution}
\usage{
dtavg(x, df, hi = 1, lo = -hi, n = as.integer(ceiling(abs(hi - lo) * 10)),
  log = FALSE)

ptavg(x, df, hi = 1, lo = -hi, n = as.integer(ceiling(abs(hi - lo) * 10)),
  lower.tail = TRUE, log = FALSE)
}
\arguments{
\item{x}{a vector}

\item{df}{degrees of freedom}

\item{hi}{upper bound of the shift range}

\item{lo}{lower bound of the shift range}

\item{n}{the number of bins for interpolation}

\item{log}{the probability is in log-scale}

\item{lower.tail}{use lower tail probablity}
}
\description{
Average of the Student t Distribution
}
\examples{
q=seq(from=-10, to=10, length.out=100)
ggplot2::qplot(q, dtavg(q, df=3, hi=3), geom='line')
x=seq(from=-10, to=10, length.out=100)
ggplot2::qplot(x, ptavg(x, df=3, hi=3), geom='line')
}
\keyword{distribution}
