% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/priors.R
\name{Prior_mu}
\alias{Prior_mu}
\alias{dprior_mu}
\alias{pprior_mu}
\alias{qprior_mu}
\alias{rprior_mu}
\alias{sprior_mu}
\title{Prior distribution on the rate in the control group}
\usage{
dprior_mu(mu, a, b, ...)

pprior_mu(q, a, b, ...)

qprior_mu(p, a, b, ...)

rprior_mu(n, a, b, ...)

sprior_mu(a, b, ...)
}
\arguments{
\item{mu,q}{vector of quantiles}

\item{a,b}{non-negative shape parameter and rate parameter}

\item{...}{other arguments passed to \code{\link{GammaDist}} or to \code{\link{summary_gamma}}}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}
}
\value{
\code{dprior_mu} gives the density, \code{pprior_mu} the distribution function, \code{qprior_mu} the quantile function, and \code{rprior_mu} samples from the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the prior distribution on the rate in the control group.










}
\details{
The prior distribution on the rate \eqn{\mu} is the Gamma distribution
with shape parameter \eqn{a} and rate parameter \eqn{b}
}
\note{
\code{Prior_mu} is a generic name for the functions documented.
}
\examples{
curve(dprior_mu(x, 2, 2), from=0, to=3)
sprior_mu(2, 2, output="pandoc")
}

