% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inference.R
\name{Inference}
\alias{Inference}
\alias{brr_estimates}
\alias{brr_intervals}
\title{Inference summaries}
\usage{
brr_intervals(x, y, S, T, a = 0.5, b = 0, c = 0.5, d = 0,
  level = 0.95, intervals = "equi-tailed*", ...)

brr_estimates(x, y, S, T, a = 0.5, b = 0, c = 0.5, d = 0,
  parameter = "phi", ...)
}
\arguments{
\item{x,y}{Observed counts}

\item{S,T}{sample sizes}

\item{a,b,c,d}{Prior parameters}

\item{level}{confidence level}

\item{intervals}{a character vector, the intervals to be returned}

\item{...}{arguments passed to \link{IntrinsicInference} and \link{Intrinsic2Inference}}

\item{parameter}{parameter of interest \code{"phi"} or \code{"VE"} (\code{=1-phi})}
}
\value{
A list of confidence intervals (\code{brr_intervals}) or estimates (\code{brr_estimates})
}
\description{
Credibility intervals, estimates


}
\note{
\code{Inference} is a generic name for the functions documented.
}
\examples{
brr_intervals(x=4, y=5, S=10, T=10, a=0.5, b=0, c=0.5, d=0)
brr_intervals(x=4, y=5, S=10, T=10, a=0.5, b=0, c=0.5, d=0, intervals=c("left","equi-tailed"))
brr_estimates(x=4, y=5, S=10, T=10, a=0.5, b=0, c=0.5, d=0)
}
\seealso{
\code{\link{confint.brr}}
}

