% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aer.R
\name{tidy.ivreg}
\alias{tidy.ivreg}
\alias{ivreg_tidiers}
\alias{aer_tidiers}
\title{Tidy a(n) ivreg object}
\usage{
\method{tidy}{ivreg}(x, conf.int = FALSE, conf.level = 0.95, instruments = FALSE, ...)
}
\arguments{
\item{x}{An \code{ivreg} object created by a call to \code{\link[AER:ivreg]{AER::ivreg()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{instruments}{Logical indicating whether to return
coefficients from the second-stage or diagnostics tests for
each endogenous regressor (F-statistics). Defaults to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
This tidier currently only supports \code{ivreg}-classed objects
outputted by the \code{AER} package. The \code{ivreg} package also outputs
objects of class \code{ivreg}, and will be supported in a later release.
}
\examples{
\dontshow{if (rlang::is_installed("AER")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load libraries for models and data
library(AER)

# load data
data("CigarettesSW", package = "AER")

# fit model
ivr <- ivreg(
  log(packs) ~ income | population,
  data = CigarettesSW,
  subset = year == "1995"
)

# summarize model fit with tidiers
tidy(ivr)
tidy(ivr, conf.int = TRUE)
tidy(ivr, conf.int = TRUE, instruments = TRUE)

augment(ivr)
augment(ivr, data = CigarettesSW)
augment(ivr, newdata = CigarettesSW)

glance(ivr)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[AER:ivreg]{AER::ivreg()}}

Other ivreg tidiers: 
\code{\link{augment.ivreg}()},
\code{\link{glance.ivreg}()}
}
\concept{ivreg tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{p.value.Sargan}{p-value for Sargan test of overidentifying restrictions.}
  \item{p.value.weakinst}{p-value for weak instruments test.}
  \item{p.value.Wu.Hausman}{p-value for Wu-Hausman weak instruments test for endogeneity.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{statistic.Sargan}{Statistic for Sargan test of overidentifying restrictions.}
  \item{statistic.weakinst}{Statistic for Wu-Hausman test.}
  \item{statistic.Wu.Hausman}{Statistic for Wu-Hausman weak instruments test for endogeneity.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
