% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-ridgelm-tidiers.R
\name{tidy.ridgelm}
\alias{tidy.ridgelm}
\alias{ridgelm_tidiers}
\title{Tidy a(n) ridgelm object}
\usage{
\method{tidy}{ridgelm}(x, ...)
}
\arguments{
\item{x}{A \code{ridgelm} object returned from \code{\link[MASS:lm.ridge]{MASS::lm.ridge()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

names(longley)[1] <- "y"
fit1 <- MASS::lm.ridge(y ~ ., longley)
tidy(fit1)

fit2 <- MASS::lm.ridge(y ~ ., longley, lambda = seq(0.001, .05, .001))
td2 <- tidy(fit2)
g2 <- glance(fit2)

# coefficient plot
library(ggplot2)
ggplot(td2, aes(lambda, estimate, color = term)) +
  geom_line()

# GCV plot
ggplot(td2, aes(lambda, GCV)) +
  geom_line()

# add line for the GCV minimizing estimate
ggplot(td2, aes(lambda, GCV)) +
  geom_line() +
  geom_vline(xintercept = g2$lambdaGCV, col = "red", lty = 2)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[MASS:lm.ridge]{MASS::lm.ridge()}}

Other ridgelm tidiers: 
\code{\link{glance.ridgelm}()}
}
\concept{ridgelm tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{GCV}{Generalized cross validation error estimate.}
  \item{lambda}{Value of penalty parameter lambda.}
  \item{term}{The name of the regression term.}
  \item{estimate}{estimate of scaled coefficient using this lambda}
  \item{scale}{Scaling factor of estimated coefficient}

}
