% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holmans_triangle.R
\name{triplot}
\alias{triplot}
\title{Plot Holmans triangle}
\usage{
triplot(labels, ...)
}
\arguments{
\item{labels}{Labels for the three corners (lower-right, top, lower-left).}

\item{...}{Passed to \code{\link[graphics]{plot}}.}
}
\value{
The (x,y) coordinates of the points plotted, if any.
}
\description{
Plot Holmans triangle (an equilateral triangle used to depict
  trinomial distributions).
}
\details{
Plot of an equilateral triangle, in order to depict trinomial
  distributions.  A trinomial distribution (that is, a trio of
  non-negative numbers that add to 1) is equated to a point in the
  triangle through the distances to the three sides.  This makes use of
  the fact that for any point in an equilateral triangle, the sum of the
  distances to the three sides is constant.
  The \code{triplot} function creates an empty triangle for use with the
  related functions \code{\link{tripoints}}, \code{\link{trilines}},
  \code{\link{triarrow}}.
}
\examples{
triplot()
x <- cbind(c(0.9, 0.05, 0.05), c(0.8, 0.1, 0.1), c(0.1, 0.9, 0), c(0, 0.9, 0.1))
tripoints(x, lwd=2, col=c("black","blue","red","green"), pch=16)
trilines(x, lwd=2, col="orange")
y <- cbind(c(0.05, 0.05, 0.9), c(0.25, 0.25, 0.5))
triarrow(y, col="blue", lwd=2, len=0.1)

}
\seealso{
\code{\link{tripoints}}, \code{\link{trilines}},
  \code{\link{triarrow}}
}
\keyword{hplot}

