% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{bayes_factor.brmsfit}
\alias{bayes_factor.brmsfit}
\alias{bayes_factor}
\title{Bayes Factors from Marginal Likelihoods}
\usage{
\method{bayes_factor}{brmsfit}(x1, x2, log = FALSE, ...)
}
\arguments{
\item{x1}{A \code{brmsfit} object}

\item{x2}{Another \code{brmsfit} object based on the same responses.}

\item{log}{Report Bayes factors on the log-scale?}

\item{...}{Additional arguments passed to 
\code{\link[brms:bridge_sampler]{bridge_sampler}}.}
}
\description{
Compute Bayes factors from marginal likelihoods.
}
\details{
Computing the marginal likelihood requires samples 
  of all variables defined in Stan's \code{parameters} block
  to be saved. Otherwise \code{bayes_factor} cannot be computed.
  Thus, please set \code{save_all_pars = TRUE} in the call to \code{brm},
  if you are planning to apply \code{bayes_factor} to your models.
  
  The computation of Bayes factors based on bridge sampling requires
  a lot more posterior samples than usual. A good conservative 
  rule of thumb is perhaps 10-fold more samples (read: the default of 4000 
  samples may not be enough in many cases). If not enough posterior
  samples are provided, the bridge sampling algorithm tends to be unstable, 
  leading to considerably different results each time it is run. 
  We thus recommend running \code{bayes_factor}
  multiple times to check the stability of the results.

  More details are provided under 
  \code{\link[bridgesampling:bayes_factor]{bridgesampling:bayes_factor}}.
}
\examples{
\dontrun{
# model with the treatment effect
fit1 <- brm(
  count ~ log_Age_c + log_Base4_c + Trt_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit1)

# model without the treatment effect
fit2 <- brm(
  count ~ log_Age_c + log_Base4_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit2)

# compute the bayes factor
bayes_factor(fit1, fit2)
}

}
\seealso{
\code{
  \link[brms:bridge_sampler]{bridge_sampler},
  \link[brms:post_prob]{post_prob}
}
}
