% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_standata.R
\name{make_standata}
\alias{make_standata}
\title{Data for \pkg{brms} Models}
\usage{
make_standata(formula, data, family = gaussian(), prior = NULL,
  autocor = NULL, cov_ranef = NULL, sample_prior = c("no", "yes",
  "only"), stanvars = NULL, knots = NULL, check_response = TRUE,
  only_response = FALSE, control = list(), ...)
}
\arguments{
\item{formula}{An object of class 
\code{\link[stats:formula]{formula}},
\code{\link{brmsformula}}, or \code{\link{mvbrmsformula}}
(or one that can be coerced to that classes): 
A symbolic description of the model to be fitted. 
The details of model specification are explained in 
\code{\link{brmsformula}}.}

\item{data}{An object of class \code{data.frame} 
(or one that can be coerced to that class) 
containing data of all variables used in the model.}

\item{family}{A description of the response distribution and link function 
to be used in the model. This can be a family function, 
a call to a family function or a character string naming the family.
Every family function has a \code{link} argument allowing to specify
the link function to be applied on the response variable.
If not specified, default links are used.
For details of supported families see 
\code{\link{brmsfamily}}.
By default, a linear \code{gaussian} model is applied.
In multivariate models, \code{family} might also be a list of families.}

\item{prior}{One or more \code{brmsprior} objects created by
\code{\link{set_prior}} or related functions 
and combined using the \code{c} method or the \code{+} operator.
See also  \code{\link{get_prior}} for more help.}

\item{autocor}{An optional \code{\link{cor_brms}} object describing 
the correlation structure within the response variable 
(i.e., the 'autocorrelation'). 
See the documentation of \code{\link{cor_brms}} for a description 
of the available correlation structures. Defaults to \code{NULL}, 
corresponding to no correlations.
In multivariate models, \code{autocor} might also be a list 
of autocorrelation structures.}

\item{cov_ranef}{A list of matrices that are proportional to the 
(within) covariance structure of the group-level effects. 
The names of the matrices should correspond to columns 
in \code{data} that are used as grouping factors. 
All levels of the grouping factor should appear as rownames 
of the corresponding matrix. This argument can be used,
among others to model pedigrees and phylogenetic effects.
See \code{vignette("brms_phylogenetics")} for more details.}

\item{sample_prior}{Indicate if samples from all specified proper priors 
should be drawn additionally to the posterior samples (defaults to 
\code{"no"}). Among others, these samples can be used to calculate 
Bayes factors for point hypotheses via \code{\link{hypothesis}}.
If set to \code{"only"}, samples are drawn solely from
the priors ignoring the likelihood, which allows among others
to generate samples from the prior predictive distribution.
In this case, all parameters must have proper priors.}

\item{stanvars}{An optional \code{stanvars} object generated
by function \code{\link{stanvar}} to define additional variables
for use in \pkg{Stan}'s program blocks.}

\item{knots}{Optional list containing user specified knot values to be 
used for basis construction of smoothing terms. 
See \code{\link[mgcv:gamm]{gamm}} for more details.}

\item{check_response}{Logical; check validity of the response?}

\item{only_response}{Logical; extract data related to the response only?}

\item{control}{A named list currently for internal usage only}

\item{...}{Other potential arguments}
}
\value{
A named list of objects containing the required data 
  to fit a \pkg{brms} model with \pkg{Stan}.
}
\description{
Generate data for \pkg{brms} models to be passed to \pkg{Stan}
}
\examples{
data1 <- make_standata(rating ~ treat + period + carry + (1|subject), 
                       data = inhaler, family = "cumulative")
names(data1)

data2 <- make_standata(count ~ log_Age_c + log_Base4_c * Trt_c 
                       + (1|patient) + (1|visit), 
                       data = epilepsy, family = "poisson")
names(data2)
         
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
