% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{emmeans-brms-helpers}
\alias{emmeans-brms-helpers}
\alias{recover_data.brmsfit}
\alias{emm_basis.brmsfit}
\title{Support Functions for \pkg{emmeans}}
\usage{
recover_data.brmsfit(object, data, resp = NULL, dpar = NULL, nlpar = NULL, ...)

emm_basis.brmsfit(
  object,
  trms,
  xlev,
  grid,
  vcov.,
  resp = NULL,
  dpar = NULL,
  nlpar = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{data, trms, xlev, grid, vcov.}{Arguments required by \pkg{emmeans}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{nlpar}{Optional name of a predicted non-linear parameter.
If specified, expected predictions of this parameters are returned.}

\item{...}{Additional arguments passed to \pkg{emmeans}.}
}
\description{
Functions required for compatibility of \pkg{brms} with \pkg{emmeans}.
Users are not required to call these functions themselves. Instead,
they will be called automatically by the \code{emmeans} function
of the \pkg{emmeans} package.
}
\examples{
\dontrun{
fit <- brm(time | cens(censored) ~ age * sex + disease + (1|patient),
            data = kidney, family = lognormal())
summary(fit)           

# summarize via 'emmeans'
library(emmeans)
rg <- ref_grid(fit)
em <- emmeans(rg, "disease")
summary(em, point.est = mean)
}
}
