% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.generics.R
\name{ranef}
\alias{ranef}
\alias{ranef.brmsfit}
\title{Extract Random Effects for \code{brmsfit} objects}
\usage{
## S3 method for class 'brmsfit'
ranef(x, estimate = "mean", var = FALSE, center.zero = TRUE, ...)
}
\arguments{
\item{x}{An object of a class of fitted models with random effects, typically a \code{brmsfit} object.}

\item{estimate}{The point estimate to be calculated for the random effects, either "mean" or "median".}

\item{var}{logical; indicating if the covariance matrix for each random effects should be computed.}

\item{center.zero}{logical; indicating if the random effects are centered around the (possibly implicit)
fixed effect or around zero (the default).}

\item{...}{Further arguments to be passed to the function specified in \code{estimate}}
}
\value{
A list of matrices (one per grouping factor), each with one row per level
 and one single column for the estimate (either mean or median).
}
\description{
A generic function to extract the random effects of each level from a fitted model object.
}
\examples{
\dontrun{
fit_e <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1+Trt_c|visit),
             data = epilepsy, family = "poisson", n.chains = 1)
## random effects means centered around zero with corresponding covariances
rf <- ranef(fit_e, var = TRUE)
attr(rf, "var")
## random effects medians centered around the corresponding fixed effect
ranef(fit_e, estimate = "median", center.zero = FALSE)
}
}

