% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_draws.R
\name{brm_marginal_draws}
\alias{brm_marginal_draws}
\title{MCMC draws from the marginal posterior of an MMRM}
\usage{
brm_marginal_draws(model, data, control = "Placebo", baseline = "Baseline")
}
\arguments{
\item{model}{Fitted \code{brms} model object from \code{\link[=brm_model]{brm_model()}}.}

\item{data}{Classed tibble with preprocessed data from \code{\link[=brm_data]{brm_data()}}.}

\item{control}{Element of the \code{group} column in the data which indicates
the control group for the purposes of calculating treatment differences.
Elements in \code{data[[group]]} are already pre-processed by \code{\link[=brm_data]{brm_data()}},
so \code{control} is automatically sanitized accordingly using
\code{make.names(control, unique = FALSE, allow_ = TRUE)}.}

\item{baseline}{Element of the \code{time} column in the data
which indicates the baseline time for the purposes of calculating
change from baseline.
Elements in \code{data[[group]]} are already pre-processed by \code{\link[=brm_data]{brm_data()}},
so \code{control} is automatically sanitized accordingly using
\code{make.names(control, unique = FALSE, allow_ = TRUE)}.}
}
\value{
A named list of tibbles of MCMC draws of the marginal posterior
distribution of each treatment group and time point:
\itemize{
\item \code{response}: on the scale of the response variable.
\item \code{change}: change from baseline, where the \code{baseline} argument determines
the time point at baseline. Only returned if the \code{role} argument is
\code{"response"}. (If \code{role} is \code{"change"}, then \code{response} already
represents change from baseline.)
\item \code{difference}: treatment effect of change from baseline, where the
\code{control} argument identifies the placebo or active control group.
In each tibble, there is 1 row per posterior sample and one column for
each type of marginal distribution (i.e. each combination of treatment
group and discrete time point.
}
}
\description{
Get marginal posterior draws from a fitted MMRM.
}
\section{Separation string}{

Post-processing in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} names each of the
group-by-time marginal means with the delimiting character string
from \code{Sys.getenv("BRM_SEP", unset = "|")}. Neither the column names
nor element names of the group and time variables can contain
this string. To set a custom string yourself, use
\code{Sys.setenv(BRM_SEP = "YOUR_CUSTOM_STRING")}.
}

\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
brm_marginal_draws(
  model = model,
  data = data,
  control = "group 1",
  baseline = "time 1"
)
}
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_data}()},
\code{\link{brm_marginal_draws_average}()},
\code{\link{brm_marginal_probabilities}()},
\code{\link{brm_marginal_summaries}()}
}
\concept{marginals}
