% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_data.R
\name{join_data}
\alias{join_data}
\title{Join external data}
\usage{
join_data(map, data, by = NULL)
}
\arguments{
\item{map}{An object of class 'sf', 'SpatialPolygonsDataFrame' or 'data.frame'}

\item{data}{A data.frame object with the data to join}

\item{by}{A character vector of variables to join by. If NULL, the default, will do
a natural join, using all variables with common names across the two tables. See
dplyr's join to more information.}
}
\value{
The function returns a 'sf', 'SpatialPolygonsDataFrame' or 'data.frame'
  object depending of the class of the map argument informed
}
\description{
A wrapper around dplyr's join
in order to facilitate the analysis
on the maps from this package
}
\examples{
# Joining population estimates data to the year of 2017
data("pop2017")
municipios <- get_brmap(geo = "City", geo.filter = list(Region = 5),
                        class = "SpatialPolygonsDataFrame")

municipios <- join_data(municipios, pop2017, by = c("City" = "mun"))

}
\seealso{
\code{\link{get_brmap}}
}
\author{
Renato Prado Siqueira \email{<rpradosiqueira@gmail.com>}
}
\keyword{IBGE}
\keyword{geographic}
\keyword{levels}
\keyword{shapefile}
\keyword{spatial}
