% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{make_auc_brainGraph}
\alias{make_auc_brainGraph}
\title{Calculate the AUC across densities of given attributes}
\usage{
make_auc_brainGraph(g.list, g.attr = NULL, v.attr = NULL,
  norm = FALSE)
}
\arguments{
\item{g.list}{A list of \code{brainGraphList} objects}

\item{g.attr}{A character vector of graph attribute name(s). Default:
\code{NULL}}

\item{v.attr}{A character vector of vertex attribute name(s). Default:
\code{NULL}}

\item{norm}{Logical indicating whether to normalize threshold values to be
between 0 and 1 (inclusive). Default: \code{FALSE}}
}
\value{
A \code{brainGraphList} object with one graph for each subject
}
\description{
Given a list of \code{brainGraphList} objects, this function will calculate
the area under the curve (AUC) across all thresholds/densities for each
subject or group.
}
\details{
If the elements of the input list do not have a \code{threshold} element (or
if it is \code{NULL}) then the AUC will be calculated on the interval
\eqn{[0, 1]} (inclusive). This has the same effect as specifying
\code{norm=TRUE} in the function call.
}
\examples{
\dontrun{
g.auc <- make_auc_brainGraph(g.fa, g.attr='E.global.wt')
}
}
