% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/centr_lev.R
\name{centr_lev}
\alias{centr_lev}
\title{Calculate a vertex's leverage centrality}
\usage{
centr_lev(g, .parallel = TRUE)
}
\arguments{
\item{g}{The igraph graph object}

\item{.parallel}{Logical indicating whether or not to use \emph{foreach}
(default: TRUE)}
}
\value{
A vector of the leverage centrality for all vertices.
}
\description{
This function calculates the leverage centrality of each vertex in a graph.
}
\details{
The leverage centrality relates a vertex's degree with the degree of its
neighbors. The equation is:
\deqn{l_i = \frac{1}{k_i} \sum_{j \in N_i} \frac{k_i - k_j}{k_i + k_j}}
where \eqn{k_i} is the degree of the \eqn{i^{th}} vertex and \eqn{N_i} is the
set of neighbors of \emph{i}. This function replaces \emph{NaN} with
\emph{NA} (for functions that have the argument \emph{na.rm}).

This function was adapted from the igraph wiki (http://igraph.wikidot.com).
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Joyce K.E., Laurienti P.J., Burdette J.H., Hayasaka S. (2010)
\emph{A new measure of centrality for brain networks}. PLoS One, 5(8):e12200.
}

