% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_braid.R
\name{geom_braid}
\alias{geom_braid}
\alias{stat_braid}
\alias{geom_braid_glass}
\alias{stat_braid_glass}
\title{BRAID Heatmaps}
\usage{
geom_braid(
  mapping = NULL,
  data = NULL,
  stat = "braid",
  position = "identity",
  ...,
  space = 1.5,
  trim = TRUE,
  shared = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_braid(
  mapping = NULL,
  data = NULL,
  geom = "tile",
  position = "identity",
  ...,
  space = 1.5,
  trim = TRUE,
  shared = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_braid_glass(
  mapping = NULL,
  data = NULL,
  stat = "braid_glass",
  position = "identity",
  ...,
  space = 1.5,
  trim = TRUE,
  shared = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_braid_glass(
  mapping = NULL,
  data = NULL,
  geom = "polygon",
  position = "identity",
  ...,
  space = 1.5,
  trim = TRUE,
  shared = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Additional parameters to be passed to \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}}

\item{space}{Parameter specifying the separation between marginal tiles and
the main grid.  Describes the distance from the center of the marginal tile
to the center of the nearest main grid tile, divided by the width or height
of the tile.  If a single value is provided, it is used for both left-right
and top-bottom margin tiles.  If two values are provided, the first is used
for left-right margin tiles and the second is used for top-bottom margin
tiles.}

\item{trim}{Should values that are finite in one dimension be dropped if
their finite coordinates lie outside the bounds of the main grid?}

\item{shared}{Should marginal offsets and trimming be calculated separately
for each facet if plots are faceted.  If \code{FALSE}, the default, each facet
will have its own bounds and marginal offsets; if \code{TRUE}, offsets will be
calculated for the full data and shared across all facets.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a
warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}
}
\description{
Summarize and plot measurements of two inputs as a discrete raster or
"stained-glass" plot
}
\details{
While the existing \code{ggplot2} package includes several functions that are
extremely effective and versatile for visualizing two-dimensional responses,
including \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}, \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}, and
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}, a number of considerations particular to combination
data make these functions, as is, somewhat difficult to use.  First, these
functions are not designed for data in which pairs of x- and y-coordinates
are duplicated; yet this is very common in experimental data.  While such
duplications can be handled prior to calling a visualization function,
handling them automatically reduces the barrier to plotting.

A second, and much more challenging consideration, is that for many drug
combination studies, drug concentrations are measured as a series of equal
ratio dilutions; visualizing such doses is most intuitive on a logarithmic
scale.  But when inputs are scaled logarithmically, zeros become infinite
and are automatically removed by nearly all \code{ggplot2} functions.  This makes
it very difficult to plot measurements of drugs in isolation and in
combination in the same plot.  \code{geom_braid} addresses this by automatically
offsetting any measurements whose transformed coordinates are infinite to
margins within the plotted space, so that all values can be plotted together.

While \code{geom_braid} is suitable for most response surfaces, some surfaces
feature measurements that are not arranged in a evenly spaced checkerboard.
For such surfaces, \code{geom_braid_glass} produces a set of Voronoi polygons
centered on the available transformed coordinates, creating what we call a
"stained glass" plot.  Marginal points are still represented by rectangles,
but with width and height such that boundaries are equidistant between
adjacent points.

\code{stat_braid} and \code{stat_braid_glass} are simply the corresponding \code{stat_}
functions for these two functions.
}
\examples{
concentrations <- c(0,2^(-3:3))
surface <- data.frame(
	  concA = rep(rep(concentrations,each=length(concentrations)),each=3),
  concB = rep(rep(concentrations,times=length(concentrations)),each=3),
  replicate = rep(c(1,2,3),times=(length(concentrations)^2))
)
surface$actual <- evalBraidModel(
  surface$concA,
 surface$concB,
 c(1, 1, 3, 3, 2, 0, 100, 100, 100)
)
surface$measure <- surface$actual + rnorm(nrow(surface),sd=7)

ggplot(surface,aes(x=concA,y=concB))+
    geom_braid(aes(fill=measure))+
    scale_x_log10()+
    scale_y_log10()+
    scale_fill_distiller(palette="RdYlBu")+
    coord_equal()+
    labs(x="Drug A",y="Drug B",fill="Effect")

glassSurface <- surface
glassSurface$concA[glassSurface$replicate==2] <-
    glassSurface$concA[glassSurface$replicate==2]*1.25
glassSurface$concB[glassSurface$replicate==3] <-
    glassSurface$concB[glassSurface$replicate==3]*1.25
glassSurface$actual <- evalBraidModel(
    glassSurface$concA,
    glassSurface$concB,
    c(1, 1, 3, 3, -0.5, 0, 60, 100, 100)
)
glassSurface$measure <- glassSurface$actual+rnorm(nrow(glassSurface),sd=7)

ggplot(glassSurface,aes(x=concA,y=concB))+
    geom_braid_glass(aes(fill=measure))+
    scale_x_log10("Drug A")+
    scale_y_log10("Drug B")+
    scale_fill_distiller("Effect",palette="RdYlBu")+
    coord_equal()

glassSurface$tilewidth <- log10(2)*0.9
glassSurface$tilewidth[glassSurface$concA==0] <- log10(2)/2

glassSurface$tileheight <- log10(2)*0.9
glassSurface$tileheight[glassSurface$concB==0] <- log10(2)/2

ggplot(glassSurface,aes(x=concA,y=concB))+
    geom_braid_glass(aes(fill=measure,width=tilewidth,height=tileheight),space=2)+
    scale_x_log10("Drug A")+
    scale_y_log10("Drug B")+
    scale_fill_distiller("Effect",palette="RdYlBu")+
    coord_equal()
}
