% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{quantreg_or2}
\alias{quantreg_or2}
\title{Bayesian quantile regression for ordinal quantile model
with 3 outcomes}
\usage{
quantreg_or2(y, x, b0, B0 , n0, d0, gamma, mcmc, p, display)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for normal distribution to sample \eqn{\beta}, default is 0.}

\item{B0}{prior variance for normal distribution to sample \eqn{\beta}}

\item{n0}{prior for shape parameter to sample \eqn{\sigma} from inverse gamma distribution, default is 5.}

\item{d0}{prior for scale parameter to sample \eqn{\sigma} from inverse gamma distribution, default is 8.}

\item{gamma}{one and only cut-point other than 0.}

\item{mcmc}{number of MCMC iterations, post burn-in.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{display}{whether to print the final output or not, default is TRUE.}
}
\value{
Returns a list with components
\itemize{
\item{\code{postMeanbeta}: }{vector with mean of sampled
 \eqn{\beta} for each covariate.}
\item{\code{postMeansigma}: }{vector with mean of sampled
 \eqn{\sigma}.}
\item{\code{postStdbeta}: }{vector with standard deviation
 of sampled \eqn{\beta} for each covariate.}
 \item{\code{postStdsigma}: }{vector with standard deviation
 of sampled \eqn{\sigma}.}
 \item{\code{allQuantDIC}: }{results of the DIC criteria.}
 \item{\code{logMargLikelihood}: }{scalar value for log marginal likelihood.}
 \item{\code{beta}: }{matrix with all sampled values for \eqn{\beta}.}
 \item{\code{sigma}: }{matrix with all sampled values for \eqn{\sigma}.}
}
}
\description{
This function estimates Bayesian quantile regression for ordinal quantile model with
3 outcomes and reports the posterior mean, posterior standard deviation, and 95
percent posterior credible intervals of \eqn{(\beta, \sigma)}.
}
\details{
Function implements the Bayesian quantile regression for
ordinal quantile model with 3 outcomes using a Gibbs sampling
procedure.

Function initializes prior and then iteratively
samples \eqn{\beta}, \eqn{\sigma} and latent variable z.
Burn-in is taken as \eqn{0.25*mcmc} and \eqn{nsim = burn}-\eqn{in + mcmc}.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y = y, x = x, B0 = 10*diag(k),
mcmc = 50, p = 0.25)

# Number of burn-in draws : 12.5
# Number of retained draws : 50
# Summary of MCMC draws :

#            Post Mean Post Std Upper Credible Lower Credible
#    beta_0   -4.5185   0.9837        -3.1726        -6.2000
#    beta_1    6.1825   0.9166         7.6179         4.8619
#    beta_2    5.2984   0.9653         6.9954         4.1619
#    sigma     1.0879   0.2073         1.5670         0.8436

# Log of Marginal Likelihood: -404.57
# DIC: 801.82

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.  DOI: 10.1214/15-BA939

Yu, K., and Moyeed, R. A. (2001). “Bayesian Quantile Regression.” Statistics and
Probability Letters, 54(4): 437–447. DOI: 10.12691/ajams-6-6-4

Casella, G., and George, E. I. (1992). “Explaining the Gibbs Sampler.”
The American Statistician, 46(3): 167-174. DOI: 10.1080/00031305.1992.10475878

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images.”
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741. DOI: 10.1109/TPAMI.1984.4767596
}
\seealso{
tcltk, \link[stats]{rnorm}, \link[stats]{qnorm},
Gibbs sampling
}
