% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{drawlatent_or2}
\alias{drawlatent_or2}
\title{Samples the latent variable z for ordinal quantile model
with 3 outcomes}
\usage{
drawlatent_or2(y, x, beta, sigma, nu, theta, tau2, gammacp)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{beta}{column vector of coefficients of dimension \eqn{(k x 1)}.}

\item{sigma}{scale factor, a scalar value.}

\item{nu}{modified scale factor, row vector.}

\item{theta}{(1-2p)/(p(1-p)).}

\item{tau2}{2/(p(1-p)).}

\item{gammacp}{row vector of cut-points including -Inf and Inf.}
}
\value{
Returns a column vector of values for latent variable z.
}
\description{
This function samples the latent variable z from a truncated
normal distribution for ordinal quantile model with 3 outcomes.
}
\details{
Function samples the latent variable z from a truncated normal
distribution.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
beta <- c(1.810504, 1.850332, 6.181163)
sigma <- 0.9684741
nu <- c(5, 5, 5, 5, 5, 5, 5, 5, 5, 5)
theta <- 2.6667
tau2 <- 10.6667
gammacp <- c(-Inf, 0, 3, Inf)
output <- drawlatent_or2(y, x, beta, sigma, nu,
theta, tau2, gammacp)

# output
#   1.257096 10.46297 4.138694
#   28.06432 4.179275 19.21582
#   11.17549 13.79059 28.3650 .. soon

}
\references{
Albert, J., and Chib, S. (1993). “Bayesian Analysis of Binary and Polychotomous
Response Data.” Journal of the American Statistical
Association, 88(422): 669–679. DOI: 10.1080/01621459.1993.10476321

Casella, G., and George, E. I. (1992). “Explaining the Gibbs Sampler.”
The American Statistician, 46(3): 167-174. DOI: 10.1080/00031305.1992.10475878

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images.”
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741. DOI: 10.1109/TPAMI.1984.4767596

Robert, C. P. (1995). “Simulation of truncated normal variables.” Statistics and
Computing, 5: 121–125. DOI: 10.1007/BF00143942
}
\seealso{
Gibbs sampling, truncated normal distribution,
\link[truncnorm]{rtruncnorm}
}
