% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_visuals_hist.R
\name{bp_hist}
\alias{bp_hist}
\title{Blood Pressure Histograms}
\usage{
bp_hist(data, subj = NULL)
}
\arguments{
\item{data}{A processed dataframe resulting from the \code{process_data} function that
contains the \code{SBP}, \code{DBP}, \code{SBP_CATEGORY}, and \code{DBP_CATEGORY} columns.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}
}
\value{
A list containing three histogram visual graphics corresponding to the SBP / DBP totals,
SBP frequency, and DBP frequency.
}
\description{
The \code{bp_hist} function serves to display the frequencies of the \code{SBP}
and \code{DBP} readings. These histograms are formatted to complement the \code{bp_scatter}
function.
}
\examples{
data("bp_jhs")
data("hypnos_data")
hyp_proc <- process_data(hypnos_data,
                         sbp = "syst",
                         dbp = "DIAST",
                         bp_datetime = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

jhs_proc <- process_data(bp_jhs,
                         sbp = "Sys.mmHg.",
                         dbp = "Dias.mmHg.",
                         bp_datetime = "DateTime",
                         hr = "pulse.bpm.")
rm(hypnos_data, bp_jhs)

bp_hist(hyp_proc)
bp_hist(jhs_proc)
}
