% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.boxcoxmix.R
\name{plot}
\alias{plot}
\alias{plot.boxcoxmix}
\title{Plot diagnostics for boxcoxmix functions}
\usage{
\method{plot}{boxcoxmix}(x, plot.opt = 1, ...)
}
\arguments{
\item{x}{an object for which a plot is desired.}

\item{plot.opt}{an integer value between 1 and 8.}

\item{\dots}{additional arguments.}
}
\value{
The plots to be printed depend on the number given in \code{plot.opt},
for the \code{np.boxcoxmix()}, \code{optim.boxcox()} and \code{tolfind.boxcox()} functions:
\item{1}{the disparities with the iteration number against the mass points} 
\item{2}{the fitted value against the response of the original and the transformed Data.}
\item{3}{probability plot of residuals of the original against the transformed data.}
\item{4}{individual posterior probabilities.}
\item{5}{control charts of residuals of the original against the transformed data.}
\item{6}{The histograms of residuals of the original against the transformed data.}
\item{7}{works only for the \code{tolfind.boxcox()} function and plots the specified range of \code{tol} against the disparities}
\item{8}{works only for the \code{optim.boxcox()} function and gives the profile likelihood function that summarises information concerning \code{lambda}.}
\item{9}{works only for the \code{Kfind.boxcox()} function and plots the specified range of \code{K} against the AIC or BIC information criteria}
\item{10}{works only for the \code{boxcoxtype()} function and gives the profile likelihood function that summarises information concerning \code{lambda} for generalized linear Mixed-effects Models.}
}
\description{
\code{plot()} is a generic function used to produce some useful diagnostic plotting of the functions:
\code{np.boxcoxmix()}, \code{optim.boxcox()} and \code{tolfind.boxcox()}.
}
\details{
Plot diagnostics for boxcoxmix functions
}
