% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{simScenPrevSensSpec}
\alias{simScenPrevSensSpec}
\title{Simulation scenario for adjusting a prevalence for sensitivity and specificity.}
\usage{
simScenPrevSensSpec(
  B = 1000,
  p,
  sens,
  spec,
  nExp,
  nExpSens,
  nExpSpec,
  alpha = 0.05,
  assumeSensSpecExact = FALSE
)
}
\arguments{
\item{B}{The number of simulations to run. Defaults to 1e3.}

\item{p}{The true value of the prevalence parameter.}

\item{sens}{The true value of the assay sensitivity parameter.}

\item{spec}{The true value of the assay specificity parameter}

\item{nExp}{The size of each simulated experiment to estimate \code{p}.}

\item{nExpSens}{The size of each simulated experiment to estimate \code{sens}.}

\item{nExpSpec}{The size of each simulated experiment to estimate \code{spec}.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{assumeSensSpecExact}{Logical; indicates whether coverage should also be computed for the situation where sensitivity and specificity are assumed to be known exactly. Defaults to FALSE.}
}
\value{
A list with 2 or 4 elements, depending whether \code{assumeSensSpecExact} is set to FALSE or TRUE:
   \item{estimate}{A single number, the proportion of simulations for which the confidence interval contained the true prevalence parameter value.}
   \item{conf.int}{A confidence interval of coverage 1-alpha for the coverage estimate.}
   \item{estimate.sensSpecExact}{Returned only if \code{assumeSensSpecExact} is set to TRUE. A single number, the proportion of simulations for which the confidence interval, derived assuming sensitivity and specificity are known exactly, contained the true prevalence parameter value.}
   \item{conf.int.sensSpecExact}{Returned only if \code{assumeSensSpecExact} is set to TRUE. A confidence interval of coverage 1-alpha for the coverage estimate in the scenario where sensitivity and specificity are assumed to be known exactly.}
}
\description{
This is a simulation to compute the coverage of the confidence interval returned by bootComb() in the case of adjusting a prevalence estimate for estimates of sensitivity and specificity.
}
\examples{
\donttest{
simScenPrevSensSpec(p=0.15,sens=0.85,spec=0.90,nExp=300,nExpSens=600,nExpSpec=400,B=1000)
  # B value only for convenience here
  # Increase B to 1e3 or 1e4 (be aware this may run for some time).
 }

}
