% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalFunctions.R
\name{identifyNormPars}
\alias{identifyNormPars}
\title{Determine the parameters of the best-fit normal / Gaussian distribution for a given confidence interval.}
\usage{
identifyNormPars(pLow, pUpp, alpha = 0.05, initPars = c(0, 1), maxiter = 1000)
}
\arguments{
\item{pLow}{The observed lower quantile .}

\item{pUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A vector of length 2 giving the initial parameter values to start the optimisation; defaults to c(50,50).}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A vector of length 2 giving the 2 parameter mean and sd for use with rnorm/dnorm/pnorm/qnorm
}
\description{
Finds the best-fit normal distribution parameters for a given confidence interval and returns the mean and sd parameters.
}
\seealso{
\code{\link{ssNormPars}}, \code{\link{optim}}, \code{\link{dnorm}}
}
