% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airy_functions.R
\name{airy_functions}
\alias{airy_functions}
\alias{airy_ai}
\alias{airy_bi}
\alias{airy_ai_prime}
\alias{airy_bi_prime}
\alias{airy_ai_zero}
\alias{airy_bi_zero}
\title{Airy Functions}
\usage{
airy_ai(x)

airy_bi(x)

airy_ai_prime(x)

airy_bi_prime(x)

airy_ai_zero(m = NULL, start_index = NULL, number_of_zeros = NULL)

airy_bi_zero(m = NULL, start_index = NULL, number_of_zeros = NULL)
}
\arguments{
\item{x}{Input numeric value}

\item{m}{The index of the zero to find (1-based).}

\item{start_index}{The starting index for the zeros (1-based).}

\item{number_of_zeros}{The number of zeros to find.}
}
\value{
Single numeric value for the Airy functions and their derivatives, or a vector of length \code{number_of_zeros} for the multiple zero functions.
}
\description{
Functions to compute the Airy functions Ai and Bi, their derivatives, and their zeros.
}
\examples{
airy_ai(2)
airy_bi(2)
airy_ai_prime(2)
airy_bi_prime(2)
airy_ai_zero(1)
airy_bi_zero(1)
airy_ai_zero(start_index = 1, number_of_zeros = 5)
airy_bi_zero(start_index = 1, number_of_zeros = 5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/airy.html}{Boost Documentation} for more details on the mathematical background.
}
