% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkNode.R
\name{linkNode}
\alias{linkMultiple}
\alias{linkNode}
\title{Link nodes to spatial data}
\usage{
linkNode(layer, network, node, intervals, categorical = NULL,
  verbose = TRUE)

linkMultiple(spatialData, network, lookup, verbose = TRUE)
}
\arguments{
\item{layer}{character (path to raster file) or an object of class "RasterLayer". The spatial data corresponding to the network node in argument \code{node}.}

\item{network}{The Bayesian network. An object of class "grain" (package \href{https://cran.r-project.org/package=gRain}{gRain}), or a character (the path to the ".net" file to be imported)}

\item{node}{character. A network node associated to the file in \code{layer} argument}

\item{intervals}{A list of numeric vectors. For categorical variables the raster values associated to each state of the node, for continuous variables the boundary values dividing into the corresponding states.}

\item{categorical}{logical. Is the node a categorical variable? Default is NULL.}

\item{verbose}{logical. If \code{verbose = TRUE} a summary of class boundaries and associated nodes and data will be printed to screen for quick checks.}

\item{spatialData}{character. The raster files corresponding to nodes}

\item{lookup}{character or a formatted list. This argument can be provided as path to a comma separated file or a formatted list (see \code{\link{setClasses}} )}
}
\value{
\code{linkNode} returns a list of objects, including the spatial data and summary information about each node.\cr
\code{linkMultiple} returns a list of lists. Each element of the list includes the spatial data and summary information for each of the input nodes.
}
\description{
\code{linkNode} links a node of the Bayesian network to its corresponding spatial dataset (in raster format), returning a list of objects, including the spatial data and relevant information about the node.\cr
\code{linkMultiple} operates on multiple rasters and nodes.
}
\details{
In future releases, this function may be rewritten to provide an S4 object instead of a list.
}
\examples{
data(ConwyData)
network <- LandUseChange
lst <- linkNode(layer=currentLU, network, node='CurrentLULC', intervals=c(2, 3, 1))
lst

## Link the Bayesian network to multiple spatial data at once, using a lookup list
data(ConwyData)
network <- LandUseChange
spatialData <- c(currentLU, slope, status)
lookup <- LUclasses
linkMultiple(spatialData, network, lookup, verbose = FALSE)
}
\seealso{
\code{\link{dataDiscretize}}; \code{\link{setClasses}}
}

