% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.package.R
\name{check.package}
\alias{check.package}
\title{Check and install packages if necessary.}
\usage{
check.package(package.name)
}
\arguments{
\item{package.name}{is the name of package to be verified.}
}
\value{
an error message if package not installed.
}
\description{
Receives a package name as parameter, check it and install if necessary.
}
\details{
This funcion receives the name of package and check if it is not installed. If the package is not installed, it is done, except for "RGraphviz" and "qgraph" packages that have a different way to be installed.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
# Choose the package name
package.name <- c("gtools")
# Check and install if not installed
check.package(package.name)
}
\author{
Elias Carvalho
}

