% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.inconsistency.plot}
\alias{network.inconsistency.plot}
\title{Plotting comparison of posterior mean deviance in the consistency model and inconsistency model}
\usage{
network.inconsistency.plot(result1, result2, with.label = T)
}
\arguments{
\item{result1}{consistency model result from running \code{\link{network.run}} function}

\item{result2}{inconsistency model result from running \code{\link{ume.network.data}} function}

\item{with.label}{indicator to show the study number; default is true.}
}
\value{
None
}
\description{
This function compares posterior mean deviance of inconsistency model and consistency model.
Such comparison provides information that can help identify the loops in which inconsistency is present.
}
\details{
This function draws network graph using igraph package
}
\examples{
network1 <- with(smoking, {
 network.data(Outcomes, Study, Treat, N = N, response = "binomial", type = "random")
})

network2 <- with(smoking, {
 ume.network.data(Outcomes, Study, Treat, N = N, response = "binomial", type = "random")
})
\donttest{
result1 <- network.run(network1)
result2 <- ume.network.run(network2)
network.inconsistency.plot(result1, result2)
}
}
\references{
S. Dias, N.J. Welton, A.J. Sutton, D.M. Caldwell, G. Lu, and A.E. Ades (2013), \emph{Evidence synthesis for decision making 4: inconsistency in networks of evidence based on randomized controlled trials}, Medical Decision Making 33(5):641-656. \doi{10.1177/0272989X12455847}
}
