% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-lrtest.R
\name{blr_test_lr}
\alias{blr_test_lr}
\alias{blr_test_lr.default}
\title{Likelihood ratio test}
\usage{
blr_test_lr(full_model, reduced_model)

\method{blr_test_lr}{default}(full_model, reduced_model)
}
\arguments{
\item{full_model}{An object of class \code{glm}; model with all predictors.}

\item{reduced_model}{An object of class \code{glm}; nested model. Optional if
you are comparing the \code{full_model} with an intercept only model.}
}
\value{
Two tibbles with model information and test results.
}
\description{
Performs the likelihood ratio test for full and reduced model.
}
\examples{
# compare full model with intercept only model
# full model
model_1 <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_test_lr(model_1)

# compare full model with nested model
# nested model
model_2 <- glm(honcomp ~ female + read, data = hsb2,
            family = binomial(link = 'logit'))

blr_test_lr(model_1, model_2)


}
\seealso{
Other model fit statistics: 
\code{\link{blr_model_fit_stats}()},
\code{\link{blr_multi_model_fit_stats}()},
\code{\link{blr_pairs}()},
\code{\link{blr_rsq_adj_count}()},
\code{\link{blr_rsq_cox_snell}()},
\code{\link{blr_rsq_effron}()},
\code{\link{blr_rsq_mcfadden_adj}()},
\code{\link{blr_rsq_mckelvey_zavoina}()},
\code{\link{blr_rsq_nagelkerke}()}
}
\concept{model fit statistics}
