% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocking.R
\name{spatialBlock}
\alias{spatialBlock}
\title{Use spatial blocks to separate train and test folds}
\usage{
spatialBlock(
  speciesData,
  species = NULL,
  rasterLayer = NULL,
  theRange = NULL,
  rows = NULL,
  cols = NULL,
  k = 5L,
  selection = "random",
  iteration = 50L,
  blocks = NULL,
  foldsCol = NULL,
  numLimit = 0L,
  maskBySpecies = TRUE,
  degMetre = 111325,
  border = NULL,
  showBlocks = TRUE,
  biomod2Format = TRUE,
  xOffset = 0,
  yOffset = 0,
  seed = 42,
  progress = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{speciesData}{A simple features (sf) or SpatialPoints object containing species data (response variable).}

\item{species}{Character (optional). Indicating the name of the column in which species data (response variable e.g. 0s and 1s) is stored.
This argument is used \emph{to make folds with evenly distributed records}. \strong{This option only works by random fold selection and with binary or
multi-class responses} e.g. species presence-absence/background or land cover classes for remote sensing image classification.
If \code{speceis = NULL} the response classes will be treated the same and only training and testing records
will be counted and balanced.}

\item{rasterLayer}{A raster object for visualisation (optional). If provided, this will be used to specify the blocks covering the area.}

\item{theRange}{Numeric value of the specified range by which blocks are created and training/testing data are separated.
This distance should be in \strong{metres}. The range could be explored by \code{spatialAutoRange()} and \code{rangeExplorer()} functions.}

\item{rows}{Integer value by which the area is divided into latitudinal bins.}

\item{cols}{Integer value by which the area is divided into longitudinal bins.}

\item{k}{Integer value. The number of desired folds for cross-validation. The default is \code{k = 5}.}

\item{selection}{Type of assignment of blocks into folds. Can be \strong{random} (default), \strong{systematic}, \strong{checkerboard}, or \strong{predefined}.
The checkerboard does not work with user-defined spatial blocks. If the selection = 'predefined', user-defined blocks and foldsCol must be supplied.}

\item{iteration}{Integer value. The number of attempts to create folds that fulfil the set requirement for minimum number
of points in each trainig and testing fold (for each response class e.g. \emph{train_0}, \emph{train_1}, \emph{test_0}
and \emph{test_1}), as specified by \code{species} and \code{numLimit} arguments.}

\item{blocks}{A sf or SpatialPolygons object to be used as the blocks (optional). This can be a user defined polygon and it must cover all
the species (response) points. If the selection = 'predefined', this argument (and foldsCol) must be supplied.}

\item{foldsCol}{Character. Indicating the name of the column (in user-defined blocks) in which the associated folds are stored.
This argument is necessary if you choose the 'predefined' selection.}

\item{numLimit}{deprecated option!}

\item{maskBySpecies}{Since version 1.1, this option is always set to \code{TRUE}.}

\item{degMetre}{Integer. The conversion rate of metres to degree. See the details section for more information.}

\item{border}{deprecated option!}

\item{showBlocks}{Logical. If TRUE the final blocks with fold numbers will be created with ggplot and plotted. A raster layer could be specified
in \code{rasterlayer} argument to be as background.}

\item{biomod2Format}{Logical. Creates a matrix of folds that can be directly used in the \pkg{biomod2} package as
a \emph{DataSplitTable} for cross-validation.}

\item{xOffset}{Numeric value between \strong{0} and \strong{1} for shifting the blocks horizontally.
The value is the proportion of block size.}

\item{yOffset}{Numeric value between \strong{0} and \strong{1} for shifting the blocks vertically. The value is the proportion of block size.}

\item{seed}{Integer. A random seed generator for reproducibility.}

\item{progress}{Logical. If TRUE shows a progress bar when \code{numLimit = NULL} in random fold selection.}

\item{verbose}{Logical. To print the report of the recods per fold.}
}
\description{
This function is deprecated and will be removed in future updates! Please use \code{\link{cv_spatial}} instead!
}
\seealso{
\code{\link{cv_spatial}}
}
