% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-gistic2.R
\name{gistic2}
\alias{gistic2}
\title{Run GISTIC2}
\usage{
gistic2(seg, refgene, ..., odir = getwd(), gistic2 = NULL)
}
\arguments{
\item{seg}{A data.frame of segmented data.}

\item{refgene}{Path to reference genome data input file (REQUIRED, see below
for file description).}

\item{...}{<\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{gistic2} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link{shQuote}}. Details see: \code{cmd_help(gistic2())}.}

\item{odir}{A string of path to the output directory.}

\item{gistic2}{A string of path to \code{gistic2} command.}
}
\value{
A \code{command} object.
}
\description{
The GISTIC module identifies regions of the genome that are
significantly amplified or deleted across a set of samples. Each aberration
is assigned a G-score that considers the amplitude of the aberration as well
as the frequency of its occurrence across samples. False Discovery Rate
q-values are then calculated for the aberrant regions, and regions with
q-values below a user-defined threshold are considered significant. For each
significant region, a "peak region" is identified, which is the part of the
aberrant region with greatest amplitude and frequency of alteration. In
addition, a "wide peak" is determined using a leave-one-out algorithm to
allow for errors in the boundaries in a single sample. The "wide peak"
boundaries are more robust for identifying the most likely gene targets in
the region. Each significantly aberrant region is also tested to determine
whether it results primarily from broad events (longer than half a chromosome
arm), focal events, or significant levels of both. The GISTIC module reports
the genomic locations and calculated q-values for the aberrant regions. It
identifies the samples that exhibit each significant amplification or
deletion, and it lists genes found in each "wide peak" region.
}
\seealso{
\url{https://broadinstitute.github.io/gistic2/}
}
