% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penaltyplot.R
\name{penaltyplot}
\alias{penaltyplot}
\title{Plot the approximate posterior distribution of the penalty vector.}
\usage{
penaltyplot(object, dimension, ...)
}
\arguments{
\item{object}{An object of class \code{coxlps}, \code{curelps}, \code{amlps}
or \code{gamlps}.}

\item{dimension}{For objects of class \code{amlps} and \code{gamlps}, the
penalty vector can have a dimension larger than one, i.e. more than a
single smooth term is present in the considered additive model. In that case,
\code{dimension} is the penalty dimension to be plotted
corresponding either to a scalar indicating the desired dimension or to a
vector indicating more than one dimension. For instance, dimension = c(1,3)
displays two separate plots of the (approximate) posterior distribution of
the (log-)penalty parameter associated to the first and the third smooth
 function respectively.}

\item{...}{Further arguments to be passed to the routine.}
}
\description{
The routine gives a graphical representation of the univariate
approximate posterior distribution of the (log-)penalty parameters for
objects of class \emph{coxlps}, \emph{curelps}, \emph{amlps} and
\emph{gamlps}.
}
\details{
When q, the number of smooth term in a (generalized) additive model is
 smaller than five, the exploration of the posterior penalty space is based
 on a grid strategy. In particular, the multivariate grid of dimension q is
 constructed by taking the Cartesian product of univariate grids in each
 dimension j = 1,...q. These univariate grids are obtained from a skew-normal
 fit to the conditional posterior p(vj|vmap[-j]),D), where vj is the
 (log-)penalty value associated to the jth smooth function and vmap[-j] is
 the posterior maximum of the (log-)penalty vector omitting the jth
 dimension. The routine displays the latter skew-normal distributions. When
 q>=5, inference is based on vmap and the grid is omitted to avoid
 computational overflow. In that case, the posterior distribution of the
 (log-)posterior penalty vector v is approximated by a multivariate Gaussian
  and the routine shows the marginal distributions.
}
\examples{
### Classic simulated data example (with simgamdata)

set.seed(123)
sim.data <- simgamdata(setting = 2, n = 250, dist = "gaussian", scale = 0.25)
plot(sim.data)         # Scatter plot of response
data <- sim.data$data  # Simulated data frame
# Fit model
fit <- amlps(y ~ z1 + z2 + sm(x1) + sm(x2), data = data, K = 15)
fit

# Penalty plot
opar <- par(no.readonly = TRUE)
par(mfrow = c(1, 2))
penaltyplot(fit, dimension = c(1, 2))
par(opar)

}
\author{
Gressani Oswaldo \email{oswaldo_gressani@hotmail.fr}.
}
