% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputePostmeanHnew.R
\name{ComputePostmeanHnew}
\alias{ComputePostmeanHnew}
\title{Compute the posterior mean and variance of \code{h} at a new predictor values}
\usage{
ComputePostmeanHnew(fit, y = NULL, Z = NULL, X = NULL, Znew, sel = NULL)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{Znew}{optional matrix of new predictor values at which to predict new \code{h}, where each row represents a new observation. This will slow down the model fitting.}

\item{sel}{A vector selecting which iterations of the BKMR fit should be retained for inference. Currently only implemented for \code{method == "r"}.}
}
\description{
Function to approximate the posterior mean and variance as a function of the estimated tau, lambda, beta, and sigsq.eps
}

