% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bizyears}
\alias{bizyears}
\title{Computes business days between two dates in years}
\usage{
bizyears(from, to, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{from}{the initial dates}

\item{to}{the final dates}

\item{cal}{an instance of \code{Calendar}}
}
\value{
\code{numeric} objects representing the amount of business days in years.
}
\description{
Returns the business days between 2 dates in years taking into account the
provided \code{Calendar} (or \code{bizdays.options$get("default.calendar")}).
}
\details{
The business days are converted to years by a division by \code{Calendar}'s
\code{dib} attribute. This is equivalent to

\preformatted{
cal <- Calendar(holidays, weekdays=c("saturday", "sunday"), dib=252)
bizdays("2013-01-02", "2013-01-31", cal)/cal$dib
}
}
\section{Date types accepted}{


The arguments \code{from} and \code{to} accept \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\section{Recycle rule}{


These arguments handle the recycle rule so vectors of dates can be provided
and once those vectors differs in length the recycle rule is applied.
}

\section{Date adjustment}{


\code{from} and \code{to} are adjusted when nonworking dates are
provided. Since \code{bizdays} function returns the amount of business days
between 2 dates, it must start and end in business days.
The default behavior, that is defined in \code{Calendar}'s instantiation with
\code{adjust.from} and \code{adjust.to}, reproduces the Excel's NETWORKDAYS.
A common and useful setting is \code{adjust.to=adjust.next} which moves
expiring maturities to the next business day, once it is not.
}
\examples{
data(holidaysANBIMA)
cal <- Calendar(holidaysANBIMA, weekdays=c("saturday", "sunday"), dib=252)
bizyears("2013-01-02", "2013-01-31", cal)
}
\seealso{
\code{\link{bizdays}} for business days.
}

