% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomqu.r
\name{ball_2d}
\alias{ball_2d}
\title{On Affine Equivariant Multivariate Quantiles}
\usage{
ball_2d(r, n = 10)
}
\arguments{
\item{r}{length of u computed as \eqn{\sqrt{u_1^2+u_2^2}}.}

\item{n}{number of u's, default is 10.}
}
\value{
a matrix of dimension (n,2) containing rowwise the distrinct u's.
}
\description{
This function generates the directions u for which the geometric quantiles  are computed.
}
\details{
The Eulicdean norm of u has to be \eqn{\le 1}, see Chakraborty, B. (2001).
}
\references{
Chakraborty, B. (2001). On affine equivariant multivariate quantiles. 
\emph{Annals of the Institute of Statistical Mathematics}, \bold{53}, 380--403. <https://doi.org/10.1023/A:1012478908041>.
}
\seealso{
\code{\link{geomqu}}.
}
\author{
Nadja Klein.
}
