% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex.R
\name{read_hex}
\alias{read_hex}
\alias{write_hex}
\title{Read and write hex bitmap font files}
\usage{
read_hex(con, ucp = NULL)

write_hex(font, con = stdout())
}
\arguments{
\item{con}{A connection object or a character string of a filename.
See \code{\link[base:readLines]{base::readLines()}} or \code{\link[base:writeLines]{base::writeLines()}} for more info.
If it is a connection it will be explicitly closed.}

\item{ucp}{Character vector of Unicode Code Points: glyphs not in this vector won't be read in.
If \code{NULL} (default) read every glyph in the font.}

\item{font}{A \code{\link[=bm_font]{bm_font()}} object.}
}
\value{
\code{read_hex()} returns a \code{\link[=bm_font]{bm_font()}} object.
\code{write_hex()} returns invisibly a character vector of the contents
of the hex font file it wrote to \code{con} as a side effect.
}
\description{
\code{read_hex()} reads in hex format bitmap font files
as a \code{\link[=bm_font]{bm_font()}} object while \code{write_hex()} writes a \code{\link[=bm_font]{bm_font()}} object
as a hex format bitmap font file.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r)

 filename <- tempfile(fileext = ".hex.gz")
 write_hex(font, gzfile(filename))

 font <- read_hex(font_file, ucp = block2ucp("Basic Latin"))
 capital_r <- font[[str2ucp("R")]]
 print(capital_r)
}
\seealso{
\code{\link[=bm_font]{bm_font()}}
}
