% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_bm_list.R
\name{as_bm_list}
\alias{as_bm_list}
\alias{as_bm_list.default}
\alias{as_bm_list.list}
\alias{as_bm_list.character}
\title{Coerce to bitmap list objects}
\usage{
as_bm_list(x, ...)

\method{as_bm_list}{default}(x, ...)

\method{as_bm_list}{list}(x, ...)

\method{as_bm_list}{character}(x, ..., font = bm_font())
}
\arguments{
\item{x}{An object that can reasonably be coerced to a \code{\link[=bm_list]{bm_list()}} object.}

\item{...}{Further arguments passed to or from other methods.}

\item{font}{A \code{\link[=bm_font]{bm_font()}} object that contains all the characters within \code{x}.}
}
\value{
A \code{\link[=bm_list]{bm_list()}} object.
}
\description{
\code{as_bm_list()} turns an existing object into a \code{\link[=bm_list]{bm_list()}} object.
In particular \code{as_bm_list.character()} turns a string into a bitmap list.
}
\examples{
  # as_bm_list.character()
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  bml <- as_bm_list("RSTATS", font = font)
  bml <- bm_extend(bml, sides = 1L, value = 0L)
  bml <- bm_extend(bml, sides = c(2L, 1L), value = 2L)
  bm <- do.call(cbind, bml)
  print(bm, px = c(" ", "#", "X"))
}
\seealso{
\code{\link[=bm_list]{bm_list()}}
}
