% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{Summaries}
\alias{Summaries}
\alias{all.bit}
\alias{any.bit}
\alias{anyNA.bit}
\alias{sum.bit}
\alias{min.bit}
\alias{max.bit}
\alias{range.bit}
\alias{summary.bit}
\alias{all.bitwhich}
\alias{any.bitwhich}
\alias{anyNA.bitwhich}
\alias{sum.bitwhich}
\alias{min.bitwhich}
\alias{max.bitwhich}
\alias{range.bitwhich}
\alias{summary.bitwhich}
\alias{all.which}
\alias{any.which}
\alias{anyNA.which}
\alias{sum.which}
\alias{min.which}
\alias{max.which}
\alias{range.which}
\alias{summary.which}
\alias{all.booltype}
\alias{any.booltype}
\alias{anyNA.booltype}
\alias{sum.booltype}
\alias{min.booltype}
\alias{max.booltype}
\alias{range.booltype}
\alias{summary.booltype}
\alias{all.ri}
\alias{any.ri}
\alias{anyNA.ri}
\alias{sum.ri}
\alias{min.ri}
\alias{max.ri}
\alias{range.ri}
\alias{summary.ri}
\title{Summaries of boolean vectors}
\usage{
\method{all}{bit}(x, range = NULL, ...)

\method{any}{bit}(x, range = NULL, ...)

\method{anyNA}{bit}(x, recursive = FALSE)

\method{sum}{bit}(x, range = NULL, ...)

\method{min}{bit}(x, range = NULL, ...)

\method{max}{bit}(x, range = NULL, ...)

\method{range}{bit}(x, range = NULL, ...)

\method{summary}{bit}(object, range = NULL, ...)

\method{all}{bitwhich}(x, range = NULL, ...)

\method{any}{bitwhich}(x, range = NULL, ...)

\method{anyNA}{bitwhich}(x, recursive = FALSE)

\method{sum}{bitwhich}(x, range = NULL, ...)

\method{min}{bitwhich}(x, range = NULL, ...)

\method{max}{bitwhich}(x, range = NULL, ...)

\method{range}{bitwhich}(x, range = NULL, ...)

\method{summary}{bitwhich}(object, range = NULL, ...)

\method{all}{which}(x, range = NULL, ...)

\method{any}{which}(x, range = NULL, ...)

\method{anyNA}{which}(x, recursive = FALSE)

\method{sum}{which}(x, range = NULL, ...)

\method{min}{which}(x, range = NULL, ...)

\method{max}{which}(x, range = NULL, ...)

\method{range}{which}(x, range = NULL, ...)

\method{summary}{which}(object, range = NULL, ...)

\method{all}{booltype}(x, range = NULL, ...)

\method{any}{booltype}(x, range = NULL, ...)

\method{anyNA}{booltype}(x, ...)

\method{sum}{booltype}(x, range = NULL, ...)

\method{min}{booltype}(x, range = NULL, ...)

\method{max}{booltype}(x, range = NULL, ...)

\method{range}{booltype}(x, range = NULL, ...)

\method{summary}{booltype}(object, range = NULL, ...)

\method{all}{ri}(x, range = NULL, ...)

\method{any}{ri}(x, range = NULL, ...)

\method{anyNA}{ri}(x, recursive = FALSE)

\method{sum}{ri}(x, ...)

\method{min}{ri}(x, ...)

\method{max}{ri}(x, ...)

\method{range}{ri}(x, ...)

\method{summary}{ri}(object, ...)
}
\arguments{
\item{x}{an object of class bit or bitwhich}

\item{range}{a \code{\link{ri}} or an integer vector of length==2 giving a
range restriction for chunked processing}

\item{\dots}{formally required but not used}

\item{recursive}{formally required but not used}

\item{object}{an object of class bit}
}
\value{
as expected
}
\description{
Fast aggregation functions for \code{\link{booltype}} vectors. namely \code{\link{bit}}, \code{\link{all}}, \code{\link{any}}, \code{\link{anyNA}},
\code{\link{min}}, \code{\link{max}}, \code{\link{range}},
\code{\link{sum}} and \code{\link{summary}}.
Now all boolean summaries (except for \code{anyNA} because the generic does not allow it) have an optional \code{range} argument to restrict the range of evalution.
Note that the boolean summaries have meaning and return values differing from logical aggregation functions: they treat \code{NA} as \code{FALSE}, 
\code{min}, \code{max} and \code{range} give the minimum and maximum positions of \code{TRUE}, \code{summary} returns counts of \code{FALSE},  \code{TRUE} and the \code{range}.
Note that you can force the boolean interpretation by calling the booltype method explicitely on any \code{\link{booltypes}} input, e.g. \code{min.booltype()}, see the examples.
}
\details{
Summaries of \code{\link{bit}} vectors are quite fast because we use a double loop that fixes each
word in a processor register.  Furthermore we break out of looping as soon
as possible. Summaries of \code{\link{bitwhich}} vectors are even faster, if the selection is very skewed.
}
\examples{

  l <- c(NA, FALSE, TRUE)
  b <- as.bit(l)
  
  all(l)
  all(b)
  all(b, range=c(3,3))
  all.booltype(l, range=c(3,3))
  
  min(l)
  min(b)
  
  sum(l)
  sum(b)
  
  summary(l)
  summary(b)
  summary.booltype(l)
}
\seealso{
\code{\link{length}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
