% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectionEG_helpers.R
\name{unimodal_test}
\alias{unimodal_test}
\title{Unimodality test for list of one or multiple sets of values}
\usage{
unimodal_test(values_list, MC_replicates= 1000)
}
\arguments{
\item{values_list}{named list of vectors of class numeric. Names in
\code{values_list} are required. If only one set of values is used the list
must contain only one element.}

\item{MC_replicates}{(numeric) number of replicates for the Monte Carlo test
to calculate p-value. Default = 1000.}
}
\value{
A data.frame with the results of the test.
}
\description{
Test of unimodality based in Hartigans' dip statistic D.
Calculations of the statistic and p-value are done as in
\code{\link[diptest]{dip.test}}.
}
\examples{
# Data
data("dist_list", package = "biosurvey")

# Testing unimodality
u_test <- unimodal_test(values_list = dist_list, MC_replicates = 500)
u_test
}
