% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_SRE.R
\name{bm_SRE}
\alias{bm_SRE}
\title{Surface Range Envelope}
\usage{
bm_SRE(
  resp.var = NULL,
  expl.var = NULL,
  new.env = NULL,
  quant = 0.025,
  do.extrem = FALSE
)
}
\arguments{
\item{resp.var}{a \code{vector}, a \code{\link[terra:vect]{SpatVector}}
without associated data (\emph{if presence-only}), 
or a \code{\link[terra:vect]{SpatVector}} object containing binary data  
(\code{0} : absence, \code{1} : presence, \code{NA} : indeterminate) 
for a single species that will be used to build the species distribution model(s)
\cr \emph{Note that old format from \pkg{sp} are still supported such as
 \code{SpatialPoints}  (if presence-only) or \code{SpatialPointsDataFrame}
 object containing binary data.}}

\item{expl.var}{a \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}}
or \code{\link[terra:rast]{SpatRaster}} object containing the explanatory variables (in 
columns or layers) that will be used to build the SRE model
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still supported such as 
\code{RasterStack} and \code{SpatialPointsDataFrame} objects. }}

\item{new.env}{a \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}}
or \code{\link[terra:rast]{SpatRaster}} object containing the explanatory variables (in 
columns or layers) that will be used to predict the SRE model
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still supported such as 
\code{RasterStack} and \code{SpatialPointsDataFrame} objects. }}

\item{quant}{a \code{numeric} between \code{0} and \code{0.5} defining the half-quantile 
corresponding to the most extreme value for each variable not to be taken into account for 
determining the tolerance boundaries of the considered species (see Details)}

\item{do.extrem}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether a \code{matrix} containing extreme conditions 
supported should be returned or not}
}
\value{
A \code{vector} or a \code{\link[terra:rast]{SpatRaster}} object, containing binary 
(\code{0} or \code{1}) values.
}
\description{
This internal \pkg{biomod2} function allows the user to run a rectilinear surface 
range envelop (SRE) (equivalent to 
\href{https://caws.org.nz/PPQ567/PPQ\%2006-1\%20pp008-9\%20Busby.pdf}{BIOCLIM}) 
using the extreme percentiles (as recommended by Nix or Busby, see References and Details).
}
\details{
\emph{Please refer to References to get more information about surface range envelop models.}

This method is highly influenced by the extremes of the data input. Whereas a linear model 
can discriminate the extreme values from the main tendency, the SRE considers them as 
important as any other data point leading to changes in predictions. \cr \cr

\emph{The more (non-colinear) variables, the more restrictive the model will be.} \cr \cr

Predictions are returned as binary (\code{0} or \code{1}) values, a site being either 
potentially suitable for all the variables, or out of bounds for at least one variable and 
therefore considered unsuitable. \cr \cr

\code{quant} determines the threshold from which the data will be taken into account for 
calibration. The default value of \code{0.05} induces that the \code{5\%} most extreme values 
will be avoided for each variable on each side of its distribution along the gradient, meaning 
that a total of \code{10\%} of the data will not be considered.
}
\examples{

library(terra)
## Load real data
data(DataSpecies)
myResp.r <- as.numeric(DataSpecies[, 'GuloGulo'])

data(bioclim_current)
myExpl.r <- rast(bioclim_current)

myRespXY <- DataSpecies[which(myResp.r == 1), c('X_WGS84', 'Y_WGS84')]
myResp.v <- classify(subset(myExpl.r, 1), 
                     matrix(c(-Inf, Inf, 0), ncol = 3, byrow = TRUE))
myResp.v[cellFromXY(myResp.v, myRespXY)] <- 1

## Compute SRE for several quantile values
sre.100 <- bm_SRE(resp.var = myResp.v,
                  expl.var = myExpl.r,
                  new.env = myExpl.r,
                  quant = 0)
sre.095 <- bm_SRE(resp.var = myResp.v,
                  expl.var = myExpl.r,
                  new.env = myExpl.r,
                  quant = 0.025)
sre.090 <- bm_SRE(resp.var = myResp.v,
                  expl.var = myExpl.r,
                  new.env = myExpl.r,
                  quant = 0.05)

## Visualize results
res <- c(myResp.v, sre.100, sre.095, sre.090)
names(res) <- c("Original distribution", "Full data calibration"
                , "Over 95 percent", "Over 90 percent")
plot(res)


}
\references{
\itemize{
  \item Nix, H.A., 1986. A biogeographic analysis of Australian elapid snakes. In: 
  \emph{Atlas of Elapid Snakes of Australia.} (Ed.) R. Longmore, pp. 4-15. 
  \bold{Australian Flora and Fauna Series Number 7.} 
  Australian Government Publishing Service: Canberra.
  \item Busby, Jeremy. BIOCLIM - a bioclimate analysis and prediction system. 
  \emph{Plant protection quarterly} \bold{6} (1991): 8-9.
}
}
\seealso{
\code{\link{bm_PseudoAbsences}}, \code{\link{BIOMOD_FormatingData}}, 
\code{\link{bm_ModelingOptions}}, \code{\link{bm_Tuning}}, 
\code{\link{bm_RunModelsLoop}}, \code{\link{BIOMOD_Modeling}},

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Wilfried Thuiller, Bruno Lafourcade, Damien Georges
}
\concept{Secundary functions}
\keyword{"surface}
\keyword{envelop"}
\keyword{models}
\keyword{quantile}
\keyword{range}
\keyword{sre}
